<?php  $thimble_doc_version = '0.2beta'; ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<title>ThimbleDoc</title>
<link rel="stylesheet" type="text/css" href="style.css" media="screen" />
</head>

<body>
<div class="div_title"><h1>ThimbleDoc - <?php echo $thimble_doc_version; ?></h1></div>
<div class="div_body">
<?php

  $action = '';
  if (isset($_REQUEST['form_action'])) $action = $_REQUEST['form_action'];
  
  // Create a new project
  
  if ($action == 'new_project') {
    $file_name = preg_replace ("/[^[:alpha:][:digit:]]/", "-", strtolower($_REQUEST['form_name']));
    $file_name = trim ($file_name, "-");
    $file_name = preg_replace ("/[-]+/", "-", $file_name);
    if ($file_name=='') {
      echo '<div class="div_error"><h2>Error</h2><p>You must specify project name !</p></div>';
      $action = '';
    } else {
      $file_name_full = '../projects/'.$file_name.'.t_doc';
      if (file_exists($file_name_full)) {
        echo '<div class="div_error"><h2>Error</h2><p>File "'.$file_name_full.'" already exists ! New project is not created.</p></div>';
        $action = '';
      } else {
        require_once('../funcs/ini_file.php');
        $project = array('source_paths' => array(), 'file_extensions' => array('ext1' => '.php'));
        $project['general']['project_name'] = $_REQUEST['form_name'];
        if ($_REQUEST['form_destination_dir']!='') $project['general']['destination_dir'] = $_REQUEST['form_destination_dir'];
        if ($_REQUEST['form_version']!='') $project['general']['version'] = $_REQUEST['form_version'];
        if ($_REQUEST['form_source_dir']!='') $project['source_paths']['url1'] = $_REQUEST['form_source_dir'];
        $ini_data = create_ini_file_content($project);
        if (@file_put_contents($file_name_full, $ini_data)) {
          chmod($file_name_full, 0777);
          echo '<div class="div_ok"><h2>Success</h2><p>Project "'.$_REQUEST['form_name'].'" has been created!</p></div>';
          $action = 'project_menu';
          $project_name = $file_name;
        } else {
          echo '<div class="div_error"><h2>Error</h2><p>Could not create file "'.$file_name.'"! Check "/project" dir permissions.</p></div>';
          $action = '';
        }
      }
    }
  }
  
  if ($action == 'source_path') {
    $file_name_full = '../projects/'.$_REQUEST['form_project_file'].'.t_doc';
    $project = @parse_ini_file($file_name_full, true);
    if (isset($_REQUEST['form_submit_delete']) && isset($_REQUEST['form_source_paths']) ) {
      $new_source_paths = array();
      foreach ($project['source_paths'] as $key => $source_path) {
        if ($key!=$_REQUEST['form_source_paths']) $new_source_paths[$key] = $source_path;
      }
      $project['source_paths'] = $new_source_paths;
    } elseif (isset($_REQUEST['form_submit_add']) && isset($_REQUEST['form_source_path'])) {
      $index = 0;
      foreach ($project['source_paths'] as $key => $source_path) {
        $i = substr($key, 3);
        if ($i > $index) $index = $i;
      }
      $project['source_paths']['url'.($index+1)] = $_REQUEST['form_source_path'];
    }
    require_once('../funcs/ini_file.php');
    $ini_data = create_ini_file_content($project);
    file_put_contents($file_name_full, $ini_data);
    $action = 'load_project';
  }
  
  
  if ($action == 'file_extension') {
    $file_name_full = '../projects/'.$_REQUEST['form_project_file'].'.t_doc';
    $project = @parse_ini_file($file_name_full, true);
    if (isset($_REQUEST['form_submit_delete']) && isset($_REQUEST['form_file_extensions']) ) {
      $new_file_extensions = array();
      foreach ($project['file_extensions'] as $key => $file_extension) {
        if ($key!=$_REQUEST['form_file_extensions']) $new_file_extensions[$key] = $file_extension;
      }
      $project['file_extensions'] = $new_file_extensions;
    } elseif (isset($_REQUEST['form_submit_add']) && isset($_REQUEST['form_file_extension'])) {
      $index = 0;
      foreach ($project['file_extensions'] as $key => $file_extension) {
        $i = substr($key, 3);
        if ($i > $index) $index = $i;
      }
      $project['file_extensions']['url'.($index+1)] = $_REQUEST['form_file_extension'];
    }
    require_once('../funcs/ini_file.php');
    $ini_data = create_ini_file_content($project);
    file_put_contents($file_name_full, $ini_data);
    $action = 'load_project';
  }
  
  
  if ($action=='generate_documentation') {
    $file_name_full = '../projects/'.$_REQUEST['form_project_file'].'.t_doc';
    $project = @parse_ini_file($file_name_full, true);
    $project['general']['destination_dir'] = $_REQUEST['form_destination_dir'];
    $project['general']['version'] = $_REQUEST['form_version'];
    $project['general']['language'] = $_REQUEST['form_language'];
    $project['general']['include_sources'] = $_REQUEST['form_sources'];
    $output_format = explode('|||', $_REQUEST['form_output_format']);
    $project['general']['output_format'] = $output_format[0];
    $project['general']['template'] = $output_format[1];
    
    if (isset($_REQUEST['form_submit'])) {
      require_once('../exporters/exporters_conf.php');
      require_once('../exporters/'.$exporters_available[$project['general']['output_format']]['file']);
      try {
        $exporter = new $exporters_available[$project['general']['output_format']]['class_name']($project['general']['project_name'], $project['source_paths'], $project['general']['destination_dir'], $project['file_extensions'], $project['general']['template'], $project['general']['language'], $project['general']['version'], $project['general']['include_sources']);
        $exporter->export();
        echo '<div class="div_ok"><h2>Success</h2><p>Documentation has been generated and saved.</p></div>';
      } catch (Exception $e) {
        echo '<div class="div_error"><h2>Error</h2><p>'.$e->getMessage().'</p></div>';
      }
    }
    require_once('../funcs/ini_file.php');
    $ini_data = create_ini_file_content($project);
    file_put_contents($file_name_full, $ini_data);
    $action = 'load_project';
  }
  
  if ($action == 'load_project') {
    $file_name_full = '../projects/'.$_REQUEST['form_project_file'].'.t_doc';
    $project = @parse_ini_file($file_name_full, true);
    if (is_array($project)) {
      $project_name = $_REQUEST['form_project_file'];
      $action = 'project_menu';
    } else {
      echo '<div class="div_error"><h2>Error</h2><p>Could not find or parse file "'.$file_name_full.'"!</p></div>';
      $action = '';
    }
    
  }
  
  // show project menu and expects $project_name and $project variables to hold data
  
  if ($action == 'project_menu') {
    
    ?>
    <p><a href="?">Return to main menu</a>
    <br /><br /></p>
    <div style="margin-bottom:20px;"><h2>Project - <?php echo $project['general']['project_name']; ?></h2></div>
    <div class="div_main">
    <form method="post" action="?">
    <p><strong>Project settings:</strong></p>
    <table border="0" cellpadding="3" cellspacing="0">
      <tr><td>Project name:</td><td><?php echo $project['general']['project_name']; ?></td></tr>
      <tr><td>Destination directory:</td><td><input type="text" name="form_destination_dir" value="<?php if (isset($project['general']['destination_dir'])) echo $project['general']['destination_dir']; ?>" size="25" /></td></tr>
      <tr><td>Version:</td><td><input type="text" name="form_version" value="<?php if (isset($project['general']['version'])) echo $project['general']['version']; ?>" size="15" /></td></tr>
    </table>
    <p><br /><strong>Generate documentation:</strong></p>
    <table border="0" cellpadding="3" cellspacing="0">
      <tr><td>Output format:</td><td>
       <select name="form_output_format" size="1">
        <?php
          require('../exporters/exporters_conf.php');
          require('../exporters/templates/templates_conf.php');
          foreach ($exporters_available as $exporter => $val) {
            foreach ($templates_available as $template => $val2) {
              if ($val2['exporter_type'] == $exporter) {
                echo '<option ';
                if ($project['general']['output_format']==$exporter && $project['general']['template'] == $template) echo 'selected ';
                echo 'value="'.$exporter.'|||'.$template.'">'.$exporter.' ('.$template.')</option>'."\n";
              }
            }
          }
        ?>
       </select>
      </td></tr>
      <tr><td>Language:</td><td>
      <select name="form_language" size="1">
        <?php
          require('../translations/translators_conf.php');
          foreach ($languages_available as $lang => $val) {
            echo '<option ';
            if ($project['general']['output_format']==$lang) echo 'selected ';
            echo 'value="'.$lang.'">'.$lang.'</option>'."\n";
          }
        ?>
       </select>
      </td></tr>
      <tr><td>Include sources:</td><td>
      <select name="form_sources" size="1">
        <option <? if ($project['general']['include_sources']=='yes') echo 'selected '; ?> value="yes">yes</option>
        <option <? if ($project['general']['include_sources']=='no') echo 'selected '; ?> value="no">no</option>
      </select>
      </td></tr>
    </table>
    <p>
     <br /><input type="submit" name="form_submit_save" value="Save project" />
     &nbsp; &nbsp; &nbsp; 
     <input type="submit" name="form_submit" value="Generate documentation" />
     <input type="hidden" name="form_project_file" value="<?php echo $project_name; ?>" />
     <input type="hidden" name="form_action" value="generate_documentation" />
    </p>
    </form>
    </div>
    
    <div class="div_main">
    <p><strong>Project source paths:</strong><br />
    Absolute or relative path to ThimbleDoc "/www" directory</p>
    <div style="float:left;margin-right:20px;">
    <form method="post" action="?">
    <select name="form_source_paths" size="5">
      <?php
        foreach ($project['source_paths'] as $key => $path) {
          echo '<option value="'.$key.'">'.$path.'</option>'."\n";
        }
      ?>
     </select>
     </div>
     <div>
       <p>
         <input type="submit" name="form_submit_delete" onclick="return confirm('Are you sure you want to delete selected source path ?');" value="Delete path" />
       </p>
     </div>
     <br style="clear:both" />
     <p>
     <input type="hidden" name="form_action" value="source_path">
     <input type="hidden" name="form_project_file" value="<?php echo $project_name; ?>">
     <strong>Add source path to project:</strong><br />
     <input type="text" name="form_source_path" size="25" />
     <input type="submit" name="form_submit_add" value="Add path" />
     </p>
     </form>
    </div>
    
    <div class="div_main">
    <p><strong>Project source file extensions:</strong><br />
    Extension with dot, e.g. ".php"</p>
    <div style="float:left;margin-right:20px;">
    <form method="post" action="?">
    <select name="form_file_extensions" size="5">
      <?php
        foreach ($project['file_extensions'] as $key => $path) {
          echo '<option value="'.$key.'">'.$path.'</option>'."\n";
        }
      ?>
     </select>
     </div>
     <div>
       <p>
         <input type="submit" name="form_submit_delete" onclick="return confirm('Are you sure you want to delete selected extension ?');" value="Delete extension" />
       </p>
     </div>
     <br style="clear:both" />
     <p>
     <input type="hidden" name="form_action" value="file_extension">
     <input type="hidden" name="form_project_file" value="<?php echo $project_name; ?>">
     <strong>Add source file extension:</strong><br />
     <input type="text" name="form_file_extension" size="6" />
     <input type="submit" name="form_submit_add" value="Add extension" />
     </p>
     </form>
    </div>
    
    <?php
    
  } else {
    
    ?>
    <div class="div_main">
    <h2>Load project</h2>
    <form method="get" action="?">
    <p>
      <input type="hidden" name="form_action" value="load_project" />
      <select name="form_project_file" size="1">
      <?php
        $regs = array();
        $projects = scandir('../projects');
        foreach ($projects as $project_file) {
        	if (preg_match('/(.*)\.t_doc$/U', $project_file, $regs)) {
        	  echo '<option value="'.$regs[1].'">'.htmlentities($regs[1]).'</option>'."\n";
        	}
        }
      ?>
      </select>
      &nbsp;
      <input type="submit" name="form_submit" value="Load project" />
    </p>
    </form>
    </div>
    <div class="div_main">
    <h2>New project</h2>
    <form method="post" action="?">
    <p>
      <input type="hidden" name="form_action" value="new_project" />
    </p>
    <table border="0" cellpadding="3" cellspacing="0">
      <tr><td>Project name:</td><td><input type="text" name="form_name" size="15" /></td></tr>
      <tr><td>Source files directory:</td><td><input type="text" name="form_source_dir" size="25" /></td></tr>
      <tr><td>Destination directory:</td><td><input type="text" name="form_destination_dir" size="25" /></td></tr>
      <tr><td>Version:</td><td><input type="text" name="form_version" size="15" /></td></tr>
    </table>
    <p>
      <input type="submit" name="form_submit" value="Create project" />
    </p>  
    </form>
    </div>
    <?php
    
  }

?>
</div>
<div class="div_footer">
Opensource by <a href="http://www.thimbleopensource.com/thimble_doc" target="_blank">www.thimbleopensource.com</a>
</div>
</body>

</html>
