<?php

/**
 * View-class which transforms ThimbleParser's result into ThimbleText
 */

  class ThimbleDocViewTT extends ThimbleDocViewApi {
    
    public $parser_result;
    public $text;
    
    // So every class and func <div id> is unique so we have no problems in thimble_text parsing
    public $class_counter = 0;
    public $func_counter = 0;
    
    function __construct($parser_result) {
      $this->parser_result = $parser_result;
      require_once('view_api.php');
      require_once('../translations/translator.php');
    }
    
    function display($title, $lang = false) {
      
      $this->text = new ThimbleDocTranslator($lang);
      
      $t_text = htmlentities($title)."\n";
      $t_text .= implode(array_pad(array(), mb_strlen($title), '#'))."\n\n";
      
      $t_text .= $this->display_header();
      
      $t_text .= $this->display_body();
      
      return $t_text;
    }
    
    function display_body() {
      
      $t_text  = $this->display_includes($this->parser_result);
      $t_text .= $this->display_functions($this->parser_result);
      $t_text .= $this->display_classes($this->parser_result);
      
      return $t_text;
      
    }
    
    function display_functions($parser_result, $inside_class = false) {
      
      $t_text = '';
      
      if ($functions = $this->find_class_in_array($parser_result, 'ThimbleParserFunction')) {
        if (count($functions) > 0) {
          foreach ($functions as $function) {
            $this->func_counter++;
            $t_text .= '((thimble_doc_function_'.$this->func_counter.')) >thimble_doc_function<'."\n";
            if ($inside_class) { 
              $title = $this->text->get_text('method').' '.$function->name;
            } else {
              $title = $this->text->get_text('function').' '.$function->name;
            }
            $t_text .= $title."\n";
            $t_text .= implode(array_pad(array(), mb_strlen($title), '='))."\n";
            
            if ($function->comment_text!='') $t_text .= '>thimble_doc_comment< '.$function->comment_text."\n\n";
            
            $t_text .= $this->display_info($function->info);
            
            if (count($function->arguments) > 0) {
              $t_text .= $this->text->get_text('arguments')."\n";
              $t_text .= implode(array_pad(array(), mb_strlen($this->text->get_text('arguments')), '-'))."\n";
              foreach ($function->arguments as $argument) {
                $t_text .= ' - *';
                if ($argument['passed_by_reference']=='&') $t_text .= '&';
                $t_text .= $argument['name'];
                if ($argument['default_value']!='') $t_text .= ' = '.$argument['default_value'];
                $t_text .= '*';
                if ($argument['comment']!='') $t_text .= ' ('.$argument['comment'].')';
                $t_text .= "\n";
              }
              $t_text .= "\n";
            }
            
            // only for @return
            foreach ($function->info as $info) {
              if ($info['info_name']=='return') {
                $title = $this->text->get_text('return');
                $t_text .= $title."\n";
                $t_text .= implode(array_pad(array(), mb_strlen($title), '-'))."\n";
                $t_text .= $info['info_value']."\n\n";
              } 
            }
            $t_text .= $this->display_includes($function->kids);
            $t_text .= $this->display_functions($function->kids);
            $t_text .= '((/thimble_doc_function_'.$this->func_counter.'))'."\n\n";
          }
        }
      }
      return $t_text;
    }
    
    function display_classes($parser_result) {
      
      $t_text = '';
      
      if ($classes = $this->find_class_in_array($parser_result, 'ThimbleParserClass')) {
        if (count($classes) > 0) {
          foreach ($classes as $class) {
            $this->class_counter++;
            $t_text .= '((thimble_doc_class_'.$this->class_counter.')) >thimble_doc_class<'."\n";
            $title = $this->text->get_text('class').' '.$class->name;
            $t_text .= $title."\n";
            $t_text .= implode(array_pad(array(), mb_strlen($title), '='))."\n";
            
            if ($class->comment_text!='') $t_text .= '>thimble_doc_comment< '.$class->comment_text."\n\n";
            
            $t_text .= $this->display_info($class->info);
            
            if (count($class->properties) > 0) {
              $t_text .= $this->text->get_text('scope')."\n";
              $t_text .= implode(array_pad(array(), mb_strlen($this->text->get_text('scope')), '-'))."\n";
              foreach ($class->properties as $property) {
                $t_text .= ' - *'.$property.'*';
                $t_text .= "\n";
              }
            }
            
            if (count($class->variables) > 0) {
              $t_text .= $this->text->get_text('variables')."\n";
              $t_text .= implode(array_pad(array(), mb_strlen($this->text->get_text('variables')), '-'))."\n";
              foreach ($class->variables as $variable) {
                $t_text .= ' - '.$variable['type'].' *'.$variable['name'].'*';
                if ($variable['comment']!='') $t_text .= ' ('.$variable['comment'].')';
                $t_text .= "\n";
              }
            }
            
            $t_text .= "\n";
            
            $t_text .= $this->display_functions($class->kids);
            $t_text .= '((/thimble_doc_class_'.$this->class_counter.'))'."\n\n";
          }
        }
      }
      return $t_text;
    }
    
    function display_includes($parser_result) {
      
      $t_text = '';
      if ($includes = $this->find_class_in_array($parser_result, 'ThimbleParserIncludes')) {
        if (isset($includes[0]->includes)) {
          $t_text .= $this->text->get_text('included_files')."\n";
          $t_text .= implode(array_pad(array(), mb_strlen($this->text->get_text('included_files')), '-'))."\n";
          foreach ($includes[0]->includes as $include) {
          	$t_text .= ' - '.$include['type'].' (* '.$include['file'].' *)'."\n";
          }
          $t_text .= "\n";
        }
      }
      return $t_text;  
    }
    
    function display_header() {
      $t_text = '';
      if ($header_info = $this->find_class_in_array($this->parser_result, 'ThimbleParserMainComment')) {
        if (isset($header_info[0]->comment_text)) {
          $t_text .= '>thimble_doc_main_comment< ';
          $t_text .= $header_info[0]->comment_text."\n\n";
        }
        if (is_array($header_info[0]->info)) {
          $t_text .= '>thimble_doc_main_info<'."\n";
          $t_text .= $this->display_info($header_info[0]->info);
          $t_text .= "\n";
        }        
      }
      return $t_text;
    }
    
    function display_info($info_array) {
      $t_text = '';
      foreach ($info_array as $info) {
        switch ($info['info_name']) {
        	case 'author':
        		$t_text .= '*'.$this->text->get_text('info_author').':* '.$info['info_value']."\n";
        		break;
          case 'copyright':
            $t_text .= '*'.$this->text->get_text('info_copyright').':* '.$info['info_value']."\n";
            break;
          case 'license':
            $t_text .= '*'.$this->text->get_text('info_license').':* '.$info['info_value']."\n";
            break;
          case 'package':
            $t_text .= '*'.$this->text->get_text('info_package').':* '.$info['info_value']."\n";
            break;
          case 'version':
            $t_text .= '*'.$this->text->get_text('info_version').':* '.$info['info_value']."\n";
            break;
          case 'deprecated':
            $t_text .= '*'.$this->text->get_text('info_deprecated').':* '.$info['info_value']."\n";
            break;
          case 'since':
            $t_text .= '*'.$this->text->get_text('info_since').':* '.$info['info_value']."\n";
            break;
        }
      }
      return $t_text;
    }
    
    function mb_ucfirst($str) {
      return mb_strtolower(mb_substr($str, 0, 1)).mb_substr($str, 1, mb_strlen($str));
    }
    
    function find_class_in_array($result_array, $class_name) {
      $found_classes = array();
      $class_name = mb_strtolower($class_name);
      foreach ($result_array as $result) {
      	if (mb_strtolower(get_class($result)) == $class_name) $found_classes[] = $result;
      }
      if (count($found_classes) > 0) {
        return $found_classes; 
      } else {
        return false;
      }
      
    }
    
  }

?>