<?php

  class ThimbleDocTranslator {
    
    public $lang;
    public $lang_class;
     
    function __construct($lang) {
      $this->lang = strtolower($lang);
      $this->set_language_vars();
    }
     
    function set_language_vars() {
      require('translators_conf.php');
      if (isset($languages_available[$this->lang])) {
        require_once($languages_available[$this->lang]['file']);
        $this->lang_class = new $languages_available[$this->lang]['class_name'];
      }
    }
    
    function get_text($key) {
      
      return $this->lang_class->get(strtolower($key));
      
    }
      
  }
  
  class ThimbleDocTranslatorBase {
     
    function get($key) {
      if (isset($this->keys[$key])) {
        return $this->keys[$key];
      } else {
        return false;
      }
    }
    
  }

?>