<?php

  function check_requirements() {
    $result = array();
    
    clearstatcache();
    
    if (version_compare(PHP_VERSION, '5.0.0', '>')) {
      $result['php5'] = array('status' => true);
    } else {
      $result['php5'] = array('status' => false, 'message' => 'ThimbleDoc requires PHP5');
    }
    
    if (is_writable('projects')) {
      $result['projects'] = array('status' => true);
    } else {
      $result['projects'] = array('status' => false, 'message' => 'Directory "/projects" is not writable, you won\'t be able to save any changes.');
    }
    
    if (file_exists('3rdparty/thimble_text/editor/thimble_text.php')) {
      $result['tt'] = array('status' => true);
    } else {
      $result['tt'] = array('status' => false, 'message' => 'ThimbleText package is required. It should be in "/3rdparty/thimble_text". Download it at www.thimbleopensource.com');
    }
    
    return $result;
  }
  
  function show_result($result_item = array()) {
    if ($result_item['status']) {
      $output = '<span style="color:#00ff00;font-weight:bold">OK</span>';
    } else {
      $output = '<span style="color:#FF0000;font-weight:bold">Missing !</span> ('.$result_item['message'].')';
    }
    return $output;
  }
  
  $result = check_requirements();
 
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<title>ThimbleDoc</title>
<link rel="stylesheet" type="text/css" href="www/style.css" media="screen" />
</head>

<body>
<div class="div_title"><h1>ThimbleDoc - 0.2beta</h1></div>
<div class="div_body">
  <h2>Installation</h2>
  <div class="div_main">
    <h3>Requirements check:</h3>
    <br /><br />
    <table border="1" cellpadding="4" cellspacing="1">
      <tr><td><strong>PHP 5</strong></td><td><?php echo show_result($result['php5']);?></td></tr>
      <tr><td><strong>/projects dir writable</strong></td><td><?php echo show_result($result['projects']);?></td></tr>
      <tr><td><strong>3rdparty module ThimbleText</strong></td><td><?php echo show_result($result['tt']);?></td></tr>
    </table>
    </div>
    <form method="post">
    <p>
    <input type="submit" name="form_submit" value="Check again" />
    </p>
    </form>
    <p>
    <br /><br /><br />
    If you have "all green", you can continue to <a href="www">ThimbleDoc main application</a>.
    </p>
    </div>
</body>

</html>
