<?php


/// Creates INI file content out of the associative array
/// @arg $data array data

function create_ini_file_content($data) {
  $content = '';
  $sections = '';

  foreach ($data as $key => $item) {
    if (is_array($item)) {
      $sections .= "\n[{$key}]\n";
      foreach ($item as $key2 => $item2) {
        if (is_numeric($item2) || is_bool($item2)) {
          $sections .= "{$key2} = {$item2}\n";
        } else {
          $sections .= "{$key2} = \"".addcslashes($item2, '"')."\"\n";
        }
      }
    } else {
      if (is_numeric($item) || is_bool($item)) {
        $content .= "{$key} = {$item}\n";
      } else {
        $content .= "{$key} = \"".addcslashes($item, '"')."\"\n";
      }
    }
  }      
  
  $content .= $sections;
  return $content;
}

?>