<?php

// function from php.net/copy for recursive directory copy

function full_copy( $source, $target ) {
  if (is_dir($source)) {
    @mkdir( $target, 0777);
    $d = dir( $source );
    while (false!==($entry=$d->read())) {
      if ( $entry == '.' || $entry == '..' ) continue;
      $Entry = $source . '/' . $entry;           
      if ( is_dir( $Entry ) ) {
        full_copy( $Entry, $target . '/' . $entry );
        continue;
      }
      copy( $Entry, $target . '/' . $entry );
    }
    $d->close();
  } else {
    copy( $source, $target);
  }
}

/// function originally from php.net/scandir with little modifications

function scan_directories($rootDir, $allowed_extensions = array()) {
    
    $dirContent = array_diff(scandir($rootDir), array('.', '..'));
    $allData = array();
    $fileCounter = 0;
    foreach($dirContent as $key => $content) {
      $path = $rootDir.'/'.$content;
      if (is_file($path) && is_readable($path)) {
        $tmpPathArray = explode("/",$path);
        $ext = explode('.', end($tmpPathArray));
        if (in_array('.'.end($ext), $allowed_extensions)) {
          $allData[$fileCounter]['file_name'] = end($tmpPathArray);
          $allData[$fileCounter]['file_path'] = $path;
          $filePartsTmp = explode(".", end($tmpPathArray));
          $allData[$fileCounter]['file_ext'] = end($filePartsTmp);
          $fileCounter++;
        }
      } elseif(is_dir($path) && is_readable($path)) {
        $dirNameArray = explode('/',$path);
        $allData[$path]['dir_path'] = $path;
        $allData[$path]['dir_name'] = end($dirNameArray);
        $content = scan_directories($path, $allowed_extensions);
        if ($content) { 
          $allData[$path]['content'] = $content; 
        } else {
          unset($allData[$path]);
        }
      }
    }
    if ($fileCounter==0) {
      return false; 
    } else {
      return $allData;
    }
}


?>