<?php

 /// This class creates in destination directory same directory tree as in source projects. It also creates index.html which has tree menu for browsing files documentation

 class ThimbleDocExportXHTMLDir {
   
   public $source_dirs = array();
   public $destination_dir;
   public $destination_dir_addon;
   public $file_extensions = array();
   public $language = '';
   public $version = '';
   public $project_name = '';
   public $template_name = '';
   public $include_sources = 'no';
   
   function __construct($project_name, $source_dirs, $destination_dir, $file_extensions, $template_name, $language = 'en', $version = '', $include_sources = 'no') {
     $this->source_dirs = $source_dirs;
     $this->destination_dir = $destination_dir;
     $this->file_extensions = $file_extensions;
     $this->language = $language;
     $this->version = $version;
     $this->project_name = $project_name;
     $this->template_name = $template_name;
     $this->include_sources = $include_sources;
   }
   
   
   function create_list_menu($dir_array, $first = false, $rel_path = '') {
     if (count($dir_array) > 0) {
       $menu = '<ul';
       if ($first) $menu .= ' id="js_tree_menu" class="js_tree_menu"';
       $menu .= '>'."\n";
       foreach ($dir_array as $item) {
         if (isset($item['dir_name'])) {
           $menu .= '<li><a href="#">'.$item['dir_name'].'</a>';
           $menu .= $this->create_list_menu($item['content'], false, $rel_path.$item['dir_name'].'/');
           $menu .= '</li>'."\n";
         }
       }
       foreach ($dir_array as $item) {
         if (isset($item['file_name'])) {
           $menu .= '<li class="dhtmlgoodies_sheet.gif"><a href="%%REL_PATH%%'.$rel_path.$item['file_name'].'.html">'.$item['file_name'].'</a></li>'."\n";
         }
       }
       $menu .= '</ul>'."\n";
     }
     return $menu;
   }
   
   function save_doc_to_file($destination_dir, $file_name, $menu, $content, $dir_depth, $source_file_path = false) {
     require('../exporters/templates/templates_conf.php');
     $template = $templates_available[$this->template_name];
     $file_name = $file_name.'.html';
     $relative_path = '';
     if ($dir_depth > 0) $relative_path = implode('', array_fill(0, $dir_depth, '../'));
     $result = file_get_contents('../exporters/templates/'.$template['dir'].'/'.$template['filename']);
     $result = str_replace('%%MENU%%', $menu, $result);
     $result = str_replace('%%CONTENT%%', $content, $result);
     $result = str_replace('%%REL_PATH%%', $relative_path, $result);
     $result = str_replace('%%FILENAME%%', $file_name, $result);
     $result = str_replace('%%PROJECT_NAME%%', $this->project_name, $result);
     $result = str_replace('%%VERSION%%', $this->version, $result);
     

     if ($this->include_sources=='yes' && $source_file_path) {
       $sources = '<div id="div_show_source_link"><p><a href="#" onclick="document.getElementById(\'div_source\').style.display=\'block\';">Show source</a></p></div>';
       $sources .= '<div id="div_source_margin"><div id="div_source">';
       $sources .= '<p><a href="#" onclick="document.getElementById(\'div_source\').style.display=\'none\';">Hide source</a></p><p>';
       $sources .= highlight_file($source_file_path, true);
       $sources .= '</p></div></div>';
       $result = str_replace('%%SOURCES%%', $sources, $result);
     } else {
       $result = str_replace('%%SOURCES%%', '', $result);
     }
 
     if (!file_put_contents($destination_dir.'/'.$file_name, $result)) {
       throw new Exception('Could not create/write to file "'.$destination_dir.'/'.$file_name.'".');
     }
   }
   
   function export_dir($dir_array, $destination_dir, $menu, $dir_depth = 0) {
     if (!file_exists($destination_dir)) {
       if (!@mkdir($destination_dir, 0777)) {
         throw new Exception('Error creating directory "'.$destination_dir.'"');
       }
     }
     require_once('../parser/parser.php');
     require_once('../views/view_xhtml.php');
     require_once('../3rdparty/thimble_text/editor/thimble_text.php');
     
     if (count($dir_array) > 0) {
       foreach ($dir_array as $item) {
         if (isset($item['dir_name'])) {
           $this->export_dir($item['content'], $destination_dir.'/'.$item['dir_name'], $menu, $dir_depth+1);
         } elseif (isset($item['file_name'])) {
           $parser = new ThimbleParser(file_get_contents($item['file_path']));
           $parser->parse();

           $view = new ThimbleDocViewXHTML($parser->result);
           $result = $view->display($item['file_name'], $this->language);
           $content = $result;

           $this->save_doc_to_file($destination_dir, $item['file_name'], $menu, $content, $dir_depth, $item['file_path']);
         }
       }
     }
   }
   
   function export_dirs($dir_array, $destination_dir) {
     require('../exporters/templates/templates_conf.php');
     require_once('../funcs/dir_funcs.php');
     $menu = $this->create_list_menu($dir_array, true);
     $this->export_dir($dir_array, $destination_dir, $menu);
     $template = $templates_available[$this->template_name];
     $this->save_doc_to_file($destination_dir, 'index', $menu, 'Click on the files at the left menu', 0);
     if (isset($template['assets_dir']) && $template['assets_dir']!='') {
       full_copy('../exporters/templates/'.$template['dir'].'/'.$template['assets_dir'], $destination_dir.'/'.$template['assets_dir']);
     }
   }
   
   function export() {
     
     require_once('../funcs/dir_funcs.php');
     
     $destination_dir = rtrim($this->destination_dir, '/');

     $destination_dir_addon = '';
     
     if ($this->version) $destination_dir_addon .= '/'.$this->version;
     
     if (count($this->source_dirs) == 1) {
       $this->destination_dir_addon = $destination_dir_addon;
       $this->export_dirs(scan_directories(reset($this->source_dirs), $this->file_extensions), $destination_dir.$destination_dir_addon);
     } else {
       $i = 0;
       foreach ($this->source_dirs as $source_dir) {
         $i++;
         $this->destination_dir_addon = $destination_dir_addon.'/'.$i;
         $this->export_dirs(scan_directories($source_dir, $this->file_extensions), $this, $destination_dir.$destination_dir_addon.'/'.$i);
       }
     }
     
   }
   
 }
 
?>