<?php

// version 0.9beta

 class ThimbleText {
   
   public $parse_elements = array();
   
   function __construct() {
     $this->register_parser(new ThimbleTextParseComments());
     $this->register_parser(new ThimbleTextParseStyles());
     $this->register_parser(new ThimbleTextParseHtml());
     $this->register_parser(new ThimbleTextParsePhp());
     $this->register_parser(new ThimbleTextParseBold());
     $this->register_parser(new ThimbleTextParseItalic());
     $this->register_parser(new ThimbleTextParseUnderline());
     $this->register_parser(new ThimbleTextParseParagraphElement());
     $this->register_parser(new ThimbleTextParseImages());
     $this->register_parser(new ThimbleTextParseLinkAddresses());
     $this->register_parser(new ThimbleTextParseEmailAddresses());
     $this->register_parser(new ThimbleTextParseLinks());
     $this->register_parser(new ThimbleTextParseBlocks());
   }
   
   function register_parser($parser_object) {
     $this->parse_elements[] = $parser_object;
   }
   
   function parse_text($text) {
     
     $text = str_replace("\r\n", "\n", $text);
     
     // replace text that we don't want to be parsed with nonsense
     preg_match_all('/\(!--(.*)--\)/uU', $text, $regs);
     $text = preg_replace('/\(!--(.*)--\)/uU', '%&#x#&%', $text);

     
     foreach ($this->parse_elements as $element) {
       $text = $element->pre_parse_element($text);
     }
     foreach ($this->parse_elements as $element) {
       $text = $element->parse_element($text);
     }
     
     // replace nonsense with previously saved text
     foreach ($regs[1] as $replacement) {
       $text = preg_replace('/%&#x#&%/uU', $replacement, $text, 1);
     }     
     
     return $text;
   }
   
 }
 
 
 
 class ThimbleTextParse {
   function parse_element($text) {
     return $text;
   }
   function pre_parse_element($text) {
     return $text;
   }
   function delete_item_from_array($lines, $i) {
     for ($x=$i; $x<(count($lines));$x++) {
       if (isset($lines[$x+1])) $lines[$x] = $lines[$x+1];
     }
     array_pop($lines);
     return $lines;
   }
 }
 
 
 class ThimbleTextParseBlocks extends ThimbleTextParse {
  
   public $replacements = array();
   
   function pre_parse_element($text) {
     
     $regs = array();
     $regs2 = array();
     
     $regex = '/\(\(([a-zA-Z0-9_-]+)\)\)[ ]*((>([a-zA-Z0-9_-]+)<[ ]*\)([:;#a-zA-Z0-9_-]+)\()|(>([a-zA-Z0-9_-]+)<)|(\)([:;#a-zA-Z0-9_-]+)\()|())/us';
     preg_match_all($regex, $text, $regs);
     foreach ($regs[1] as $block_start) {
       $regex = '/\(\('.$block_start.'\)\)[ ]*((>([a-zA-Z0-9_-]+)<[ ]*\)([:;#a-zA-Z0-9_-]+)\()|(>([a-zA-Z0-9_-]+)<)|(\)([:;#a-zA-Z0-9_-]+)\()|())(.*)\(\(\/'.$block_start.'\)\)/us';
       preg_match($regex, $text, $regs2);
       if (count($regs2) > 0) {
         $text = preg_replace($regex, '&^#block#^&', $text);
         $replacement = array();
         if (isset($regs2[3]) && isset($regs2[4]) && $regs2[3]!='' && $regs2[4]!='') {
           $replacement['class'] = $regs2[3];
           $replacement['style'] = $regs2[4];
           $replacement['text'] = $regs2[10];
         } elseif (isset($regs2[6]) && $regs2[6]!='') {
           $replacement['class'] = $regs2[6];
           $replacement['text'] = $regs2[10];
         } elseif (isset($regs2[8]) && $regs2[8]!='') {
           $replacement['style'] = $regs2[8];
         } else {
           $replacement['text'] = $regs2[10];
         }
         $replacement['id'] = $block_start;
         $this->replacements[] = $replacement;
       }
     }
     return $text;
   }
   
   function parse_element($text) {
     
     foreach ($this->replacements as $block) {
       $tt = new ThimbleText();
       $block_text = '<div id="'.$block['id'].'"';
       if (isset($block['class'])) $block_text .= ' class="'.$block['class'].'"';
       if (isset($block['style'])) $block_text .= ' style="'.$block['style'].'"';
       $block_text .= '>'."\n".$tt->parse_text($block['text'])."\n".'</div>';
       $text = preg_replace('/&\^#block#\^&/u', $block_text, $text, 1);
       
     }
     
     return $text;
     
   }
   
 }
 
 
 class ThimbleTextParseStyles extends ThimbleTextParse {
   
   public $regex = '/\)([a-zA-Z0-9_-]+)=([^ ]+)\(/uU';
   
   function pre_parse_element($text) {
     
     $regs = array();
     preg_match_all($this->regex, $text, $regs);
     
     if (is_array($regs[1])) {
       for ($i=0;$i<count($regs[1]);$i++) {
         $style = ')'.$regs[2][$i].'(';
         // replace name styles by their definition
         $text = str_replace(')'.$regs[1][$i].'(', $style, $text);
         // clear definitions from the original text
         $text = str_replace($regs[0][$i], '', $text); 
         
       }
     }
     return $text;
     
   }
   
 }
 
 class ThimbleTextParsePhp extends ThimbleTextParse {
   
   function parse_element($text) {

     $regex = "/\(php\)(.*)\(\/php\)/suU";
     $regs = array();
     preg_match_all($regex, $text, $regs);
     for ($i=0;$i<count($regs[0]);$i++) {
       $replace = highlight_string(trim($regs[1][$i]), true);
       $text = preg_replace($regex, $replace, $text, 1);
     }
     return $text;
   }
   
 }
 
 
 class ThimbleTextParseHtml extends ThimbleTextParse {
   
   function parse_element($text) {

     $regex = "/\(html\)(.*)\(\/html\)/suU";
     $regs = array();
     preg_match_all($regex, $text, $regs);
     for ($i=0;$i<count($regs[0]);$i++) {
       $replace = htmlentities($regs[1][$i]);
       $text = preg_replace($regex, $replace, $text, 1);
     }
     return $text;
   }
   
 }
 
 class ThimbleTextParseLinkAddresses extends ThimbleTextParse {
   
   function parse_element($text) {
     $regex = '/(([\/\^\[]?)|(="))(((http:\/\/)|(www))[A-Za-z0-9\.\/%&=\?\-_]+)/';
     $regex_replace = '/(^|[^\/\^\[=">])(((http:\/\/)|(www))[A-Za-z0-9\.\/%&=\?\-_]+)/';
     $regs = array();
     preg_match_all($regex, $text, $regs);
     for ($i=0;$i<count($regs[0]);$i++) {
       if ($regs[1][$i]=='/' || $regs[1][$i]=='') {
         if ($regs[1][$i]=='/') {
           $replace = $regs[4][$i];
         } else {
           $replace = $regs[4][$i];
           if ($regs[5][$i]=='www') $replace = 'http://'.$replace;
           $replace = '<a href="'.$replace.'"';
           if ($regs[1][$i]=='^') $replace .= ' target="_blank"';
           $replace .='>'.$regs[4][$i].'</a>';
         }
         $text = preg_replace($regex_replace, '$1'.$replace, $text, 1);
       }
     }
     
     return $text;
   }
   
 }
 
 class ThimbleTextParseEmailAddresses extends ThimbleTextParse {
   
   function parse_element($text) {
     $regex = '/([\/]?)(([\w\-\.]+)@((\[([0-9]{1,3}\.){3}[0-9]{1,3}\])|(([\w\-]+\.)+)([a-zA-Z]{2,4})))/';
     $regs = array();
     preg_match_all($regex, $text, $regs);
     for ($i=0;$i<count($regs[0]);$i++) {
       if ($regs[1][$i]=='/') {
         $replace = $regs[2][$i];
       } else {
         $replace = str_replace('@', '&#64;', $regs[0][$i]);
         $replace = '<a href="mailto:'.$replace.'">'.str_replace('@','&#64;<!---->' ,$regs[0][$i]).'</a>';
       }
       $text = preg_replace($regex, $replace, $text, 1);
     }
     
     return $text;
   }
   
 }
 
 class ThimbleTextParseComments extends ThimbleTextParse {
   
   function pre_parse_element($text) {
     $text = preg_replace('/([^|])\|\|.*\n/uU', "$1\n", $text);
     return $text;
   }
   
 }
 
 class ThimbleTextParseLinksImagesBase extends ThimbleTextParse {
   
   public $regex = '';
   
   function parse_params_values($params_notparsed, $shift_off_first_element = false, &$shifted_element = false) {
     $params_parsed = array();
     if ($params_notparsed!='') {
       $params = explode(',', $params_notparsed);
       if ($shift_off_first_element) {
         $shifted_element = $params[0];
         array_shift($params);
       }
       foreach ($params as $param) {
         $param2 = explode('=', $param);
         $params_parsed[$param2[0]] = $param2[1];
       }
     }
     return $params_parsed;      
   }
   
   function parse_params($params_text) {
     if (is_array($params_text)) {
       
       $params = array();
       foreach ($params_text as $param_key => $param_value) {
         $params[] = strtolower($param_key).'="'.$param_value.'"';
       }
       $params = implode(' ', $params);
     } else {
       $params = '';
     }
     return $params;
   }
   
   function pre_parse_element($text) {
     $regex = $this->regex;
     $regs = array();
     preg_match_all($regex, $text, $regs);
     if (is_array($regs[1])) {
       for ($i=0;$i<count($regs[1]);$i++) {
         if ($regs[3][$i]=='^') {
           $target = '_blank';
         } else {
           $target = '';
         }
         if (strpos($regs[2][$i], ',')) {
           $shifted_element = '';
           $params_parsed = $this->parse_params_values($regs[2][$i], true, $shifted_element);
           if ($target!='') $params_parsed['target'] = $target;
           $this->links[$regs[1][$i]] = array('url' => $shifted_element, 'params' => $params_parsed);
         } else {
           if ($target!='') $params_parsed['target'] = $target;
           $this->links[$regs[1][$i]] = array('url' => $regs[2][$i]);
         }
         
         if (isset($regs[3][$i]) && $regs[3][$i]!='') {
           $this->links[$regs[1][$i]]['align'] = $regs[3][$i];
         }
         
         $text = explode("\n", $text);
         for ($i2=0;$i2<count($text);$i2++) {
           if (strstr($text[$i2], $regs[0][$i])) {
             for ($x=$i2; $x<(count($text)-1);$x++) {
               $text[$x] = $text[$x+1];
             }
             array_pop($text);
           }
         }
         $text = implode("\n", $text);
       }
     }
     return $text;
   }
   
 }
 
 
 // images
 
 class ThimbleTextParseImages extends ThimbleTextParseLinksImagesBase {
   
   public $links = array();
    
   function __construct() {
     $this->regex = "/\{([\w]+)\=([^\}<>]+)([<>]?)\}/";
   }

   function parse_param_align($align_sign) {
     if ($align_sign=='<') {
       return ' align="left"';
     } elseif ($align_sign=='>') {
       return ' align="right"';
     }
   }
   
   function parse_element($text) {
   
     foreach ($this->links as $link_name => $link) {
       $regex = "/\{".$link_name.",?([^\}<>]*)([<>]?)\}/";
       $regs = array();
       preg_match_all($regex, $text, $regs);
       for ($i=0;$i<count($regs[1]);$i++) {
         $params = $this->parse_params_values($regs[1][$i]);        
         if (is_array($link['params'])) {
           $params = array_merge($link['params'], $params);
         }
         
         // some default parameters
         if (!isset($params['border'])) $params['border']='0';
         if (!isset($params['alt'])) $params['alt']='';
         
         $params = $this->parse_params($params);
         if ($regs[2][$i]) {
           $params .= $this->parse_param_align($regs[2][$i]); 
         } elseif ($link['align']!='') {
           $params .= $this->parse_param_align($link['align']);
         }
         $text = str_replace($regs[0][$i], '<img src="'.$link['url'].'" '.$params.' />', $text);
       }
     }
     
     $regex = "/\{([^\},<>]+),?([^\}<>]*)([<>]?)\}/";
     $regs = array();
     preg_match_all($regex, $text, $regs);
     for ($i=0;$i<count($regs[1]);$i++) {
       $params = $this->parse_params_values($regs[2][$i]);
       
       // some default parameters
       if (!isset($params['border'])) $params['border']='0';
       if (!isset($params['alt'])) $params['alt']='';
       
       $params = $this->parse_params($params);
       if ($regs[3][$i]) {
         $params .= $this->parse_param_align($regs[3][$i]); 
       } 
       $text = str_replace($regs[0][$i], '<img src="'.$regs[1][$i].'" '.$params.' />', $text);
     }
   
     return $text;
   }
   
 }
 
 
 
 
 class ThimbleTextParseLinks extends ThimbleTextParseLinksImagesBase {
   
   public $links = array();
   
   function __construct() {
     $this->regex = "/\[([\w]+)\=([^\]\^]+)([\^]?)\]/";
   }
   
   function parse_element($text) {
    
     foreach ($this->links as $link_name => $link) {
       $regex = "/\[".$link_name."(\]|,([^\]\^]+)(\^?)\])/";
       $regs = array();
       preg_match_all($regex, $text, $regs);
       for ($i=0;$i<count($regs[1]);$i++) {
         $params = $this->parse_params_values($regs[2][$i]);
         if (isset($link['params']) && is_array($link['params'])) {
           $params = array_merge($link['params'], $params);
         }
         if (isset($regs[3][$i]) && $regs[3][$i]=='^') {
           $params['target'] = '_blank';
         }
         $params = $this->parse_params($params);
         $text = str_replace($regs[0][$i], '<a href="'.$link['url'].'" '.$params.'>', $text);
       }
       $text = str_replace('[/'.$link_name.']', '</a>', $text);
      
     }
     
     // parse inline links
     
     $text = str_replace('[/]', '</a>', $text);
     
     //$regex = "/\["."([a-zA-Z]+[:\/\/]+[A-Za-z0-9\-_]+\\.+[A-Za-z0-9\.\/%&=\?\-_]+)".",?([^\]\^]*)(\^?)\]/";
     $regex = "/\["."([:A-Za-z0-9\.\/%&=\?\-_]+)".",?([^\]\^]*)(\^?)\]/";
     $regs = array();
     preg_match_all($regex, $text, $regs);
     for ($i=0;$i<count($regs[1]);$i++) {
       $params = $this->parse_params_values($regs[2][$i]);
       if (isset($regs[3][$i]) && $regs[3][$i]=='^') {
         $params['target'] = '_blank';
       }
       $params = $this->parse_params($params);
       $text = str_replace($regs[0][$i], '<a href="'.$regs[1][$i].'" '.$params.'>', $text);
     }
     
     // parse email links
     $regex = '/\[(([\w\-\.]+)@((\[([0-9]{1,3}\.){3}[0-9]{1,3}\])|(([\w\-]+\.)+)([a-zA-Z]{2,4})))\]/';
     preg_match_all($regex, $text, $regs);
     for ($i=0;$i<count($regs[1]);$i++) {
       $replace = str_replace('@', '&#64;', $regs[1][$i]);
       $text = str_replace($regs[0][$i], '<a href="mailto:'.$replace.'">', $text);
     }
     
     return $text;
   }
   
 }
 
 class ThimbleTextParseParagraphElement extends ThimbleTextParse {
   
   public $heading_elements = array('h1' => '##', 'h2' => '==', 'h3' => '--');
   
   function parse_element($text) {
     
     $lines = explode("\n", $text);
     
     $was_empty_line = true;
     $was_empty_line_with_space = false;
     $empty_line_with_definition = false;
     $paragraph = false;
     $heading_line = false;
     
     $block_element = '&^#block#^&';
     
     // unordered list
     $list = false;
     $list_regex = "/^([ ]*)-[^-][ ]*([^-]+)/u";
     $list_indent = false;
     $list_deep = 0;
     $list_deep_data = array();
     $was_list = false;
     
     // ordered list
     $o_list = false;
     $o_list_regex = "/^([ ]*)[0-9a-zA-Z]{1,2}[)\.][ ]*(.*)/u";
     $o_list_deep = 0;
     $o_list_indent = false;
     $o_list_deep_data = array();
     $was_o_list = false;
     
     $regs = array();
     
     for ($i = 0; $i < count($lines); $i++) {
       
       $empty_line_with_definition = false;
       
       if (trim($lines[$i])==$block_element) {
         if ($paragraph) $lines[$i-1] = $lines[$i-1]."</p>";
         $paragraph = false;
         $was_empty_line = true;
         continue;
       }
       
       if (isset($lines[$i+1])) {
         $nextline = $lines[$i+1];
       } else {
         $nextline = false;
       }
       
       if (isset($lines[$i+2])) {
         $nextline2 = $lines[$i+2];
       } else {
         $nextline2 = false;
       }
       
       $css_class = '';
       // if class is used, we extract it from the line beginning and save it for later 
       if (preg_match('/^([ ]*)>([0-9a-zA-Z_]+)<(.*)/u', $lines[$i], $regs)) {
         $css_class = $regs[2];
         $lines[$i] = $regs[1].$regs[3];
       }
       
       $css_style = '';
       // if style is used, we extract it from the line beginning and save it for later 
       if (preg_match('/^([ ]*)\)([^(]+)\((.*)/u', $lines[$i], $regs)) {
         $css_style = $regs[2];
         $lines[$i] = $regs[1].$regs[3];
       }
       
       if ($list && preg_match($list_regex, $lines[$i], $regs)) {
         if ($list_indent===false) $list_indent = mb_strlen($regs[1]);
         $line = '';
         if ($list_indent < mb_strlen($regs[1])) {
           $line = '<ul>'."\n";
           $list_deep++;
           $list_deep_data[mb_strlen($regs[1])] = $list_deep;
         }
         if ($list_indent > mb_strlen($regs[1])) {
           $list_deep--;
           // here we check if <li> has not jumped "back" by more than one jump, if so, we have to add more </ul>s
           if ($list_deep_data[mb_strlen($regs[1])] < $list_deep) {
             end($list_deep_data);
             for($x=(count($list_deep_data)-1);$x>=0;$x--) {
               if (current($list_deep_data) > $list_deep) {
                 $line = '</ul>'.$line;
               }
               prev($list_deep_data);
             }
           }
           $line = '</ul>'."\n".$line;
           
         }
         $line = $line.'<li>'.$regs[2].'</li>';
         $lines[$i] = $line;
         $list_indent = strlen($regs[1]);
       }

       if (substr(trim($lines[$i]), 0, 2) == '__') {
         if (!$paragraph) $lines[$i] = '<br style="clear:both" />'; else $lines[$i] = '';
         $empty_line_with_definition = true;
       } elseif (substr(trim($lines[$i]), 0, 2) == '<_') {
         if (!$paragraph) $lines[$i] = '<br style="clear:left" />'; else $lines[$i] = '';
         $empty_line_with_definition = true;
       } elseif (substr(trim($lines[$i]), 0, 2) == '>_') {
         if (!$paragraph) $lines[$i] = '<br style="clear:right" />'; else $lines[$i] = '';
         $empty_line_with_definition = true;
       }
       
       if ($lines[$i] != '%&#x#&%' && !$paragraph && ($lines[$i]!='' || $css_class!='') && ($was_empty_line || $was_list || $was_o_list) && !$o_list && !$list && !preg_match($list_regex, $lines[$i]) && !preg_match($o_list_regex, $lines[$i]) && !in_array(substr(ltrim($nextline), 0, 2), $this->heading_elements)) {
         $paragraph = true;
         if (preg_match('/^([ ]{2,})(.*)/u', $lines[$i], $regs)) {
           $tag = '<p style="text-indent:'.(mb_strlen($regs[1])-1).'em"';
           $lines[$i] = str_replace($regs[0], $regs[2], $lines[$i]);
         } else {
           $tag = '<p';
         }
         if ($css_class!='') $tag .= ' class="'.$css_class.'"';
         if ($css_style!='') $tag .= ' style="'.$css_style.'"';
         $tag .= '>';
         if (trim($lines[$i])=='' && $css_class!='') $empty_line_with_definition = true;
         $lines[$i] = $tag.$lines[$i];
         $heading_line = false;
       }
       
       if ($paragraph && ($nextline=='' || $heading_line || in_array(substr(ltrim($nextline2), 0, 2), $this->heading_elements) || preg_match($list_regex, $nextline) || preg_match($o_list_regex, $nextline))) {
         $lines[$i] = $lines[$i].'</p>';
         $paragraph = false;
       }
       
       // this first condition if only for case when list is right at the beginning of the text. Not pretty, but it works.
       if (preg_match($list_regex, $lines[$i], $regs) && $i==0) {
         $list_indent = mb_strlen($regs[1]);
         $lines[$i] = '<ul>'."\n".'<li>'.$regs[2].'</li>';
         $list = true;
       } 
       if (preg_match($list_regex, $nextline)) {
         if (!$list) {
           $z = count($lines);
           for ($x=$z;$x>$i;$x--) {
             $lines[$x] = $lines[$x-1];
           }
           $lines[$i+1] = '<ul>';
         }
         $list = true;
       } else {
         if ($list) {
           $lines[$i] = $lines[$i]."\n".'</ul>';
           for ($x=0;$x<$list_deep;$x++) $lines[$i] = $lines[$i]."\n".'</ul>';
           $list_indent = false;
           $list_deep = 0;
           $list_deep_data = array();
           $was_list = true;
           $paragraph = false;
         } else { 
           $was_list = false;
         }
         $list = false;
       }
       
       if (preg_match($o_list_regex, $lines[$i], $regs)) {
         if (!$o_list) {
           $o_list = true;
           $lines[$i] = '<ol>'."\n".'<li>'.$regs[2].'</li>';
           $o_list_deep = 0;
           $o_list_indent = mb_strlen($regs[1]);
           $o_list_deep_data[$o_list_indent] = $o_list_deep;
         } else {
           if ($o_list_indent < mb_strlen($regs[1])) {
             $o_list_deep++;
             $o_list_indent = mb_strlen($regs[1]);
             $o_list_deep_data[$o_list_indent] = $o_list_deep;
             $lines[$i] = '<ol>'."\n".'<li>'.$regs[2].'</li>';
           } elseif ($o_list_indent > mb_strlen($regs[1])) {
             $line = '';
             $o_list_deep = $o_list_deep_data[$regs[1]];
             end($o_list_deep_data);
             for($x=(count($o_list_deep_data)-1);$x>=0;$x--) {
               if (current($o_list_deep_data) > $o_list_deep) {
                 $line = '</ol>'."\n".$line;
               }
               prev($o_list_deep_data);
             }
             $o_list_indent = mb_strlen($regs[1]);
             $lines[$i] = $line.'<li>'.$regs[2].'</li>';
           } else {
             $lines[$i] = '<li>'.$regs[2].'</li>';
           }
         }
         if (!preg_match($o_list_regex, $nextline)) {
           $lines[$i] = $lines[$i]."\n".'</ol>';
           for ($x=0;$x<$o_list_deep;$x++) $lines[$i] = $lines[$i]."\n".'</ol>';
           $o_list = false;
           $was_o_list = true;
           $o_list_deep = 0;
           $o_list_deep_data = array();
         } 
       } else {
         $was_o_list = false;
       }
       
       if (($paragraph && trim($nextline)!=$block_element && !$list && !$o_list && !in_array(substr(ltrim($nextline), 0, 2), $this->heading_elements)) || ($lines[$i]==' ')) {
         if ($lines[$i]==' ') {
           $lines[$i] = '<br />';
           $was_empty_line_with_space = true;
         } elseif (!$empty_line_with_definition) {
           if (substr(trim($nextline), 0, 2) == '__') {
             $lines[$i] .= '<br style="clear:both" />';
           } elseif (substr(trim($nextline), 0, 2) == '<_') {
             $lines[$i] .= '<br style="clear:left" />';
           } elseif (substr(trim($nextline), 0, 2) == '>_') {
             $lines[$i] .= '<br style="clear:right" />';
           } else {
             $lines[$i] = rtrim($lines[$i]).'<br />'; 
           }
         }
       }
             
       if (!$was_empty_line && in_array(substr(ltrim($lines[$i]), 0, 2), $this->heading_elements)) {
         $element_name = array_search(substr(ltrim($lines[$i]), 0, 2), $this->heading_elements);
         $lines[$i-1] = '<'.$element_name.'>'.$lines[$i-1].'</'.$element_name.'>';
         $lines = $this->delete_item_from_array($lines, $i);
         $i = $i-1; 
         $heading_line = true;
         $was_empty_line = true;
       } else {
         $heading_line = false;
       }
       
       
       if ($lines[$i]=='' || $lines[$i]==' ') { 
         $lines = $this->delete_item_from_array($lines, $i);
         $i = $i-1 ;
         $was_empty_line = true; 
       } elseif ($was_empty_line_with_space) {
         $was_empty_line = true;
         $was_empty_line_with_space = false;
       } elseif(!$heading_line) {
         $was_empty_line = false;
       }
     }
     
     $text = implode("\n", $lines);
     
     return $text;
     
   }
   
 }
 
 
 class ThimbleTextParseBlockElement extends ThimbleTextParse {
   
   public $parse_element = '';
   public $parse_replace_first_element = '';
   public $parse_replace_last_element = '';
   
   function parse_element($text) {
     $parse_element = addcslashes($this->parse_element, '*-');
     $regex = "/(^|[^\/".$parse_element."])".$parse_element."([^".$parse_element.'].*[^\/'.$parse_element."])".$parse_element."([^".$parse_element."]|$)/suU";
     $regs = array();
     preg_match_all($regex, $text, $regs);
     for ($i=0;$i<count($regs[0]); $i++) {
       $regs[2][$i] = str_replace('/'.$this->parse_element, $this->parse_element, $regs[2][$i]);
       $replace_with = $regs[1][$i].$this->parse_replace_first_element.$regs[2][$i].$this->parse_replace_last_element.$regs[3][$i];
       $text = str_replace($regs[0][$i], $replace_with, $text);
     }
     
     $regex = "/\/(".$parse_element."[^".$parse_element."])/uU";
     $regs = array();
     preg_match_all($regex, $text, $regs);
     for ($i=0;$i<count($regs[0]); $i++) {
       $text = str_replace($regs[0][$i], $regs[1][$i], $text);
     }
     
     return $text;
   }
   
 }
 
 class ThimbleTextParseBold extends ThimbleTextParseBlockElement {
     function __construct() {
      $this->parse_element = '*';
      $this->parse_replace_first_element = '<strong>';
      $this->parse_replace_last_element = '</strong>';
    }
 }

class ThimbleTextParseItalic extends ThimbleTextParseBlockElement {
     function __construct() {
      $this->parse_element = '**';
      $this->parse_replace_first_element = '<em>';
      $this->parse_replace_last_element = '</em>';
    }
 }

class ThimbleTextParseUnderline extends ThimbleTextParseBlockElement {
     function __construct() {
      $this->parse_element = '--';
      $this->parse_replace_first_element = '<u>';
      $this->parse_replace_last_element = '</u>';
    }
 }

?>