<?php
  // outputs html for editor
  class ThimbleTextEditor {
    
    // default setting of properties
    
    public $textarea_id = 'thimble_text';
    public $textarea_name = 'thimble_text';
    public $textarea_rows = 15;
    public $textarea_cols = 60;
    public $textarea_style = '';
    public $textarea_text = '';
    public $textarea_show_controls = true;
    
    // relative or absolute URL path to a folder where images are located, e.g. images (without slash at the end)
    public $images_url = 'images';
    
    public $table_name = 'thimble_text';
    // row 'id' in database 
    public $table_id = false;
    
    function html_head() {
      $function_name = $this->textarea_name.'_button_click';
      $jscript = <<<END
<script>
function $function_name(open_tag, close_tag, tag_text) {
  var text_element = document.getElementById('$this->textarea_id');
  if (text_element.setSelectionRange > '') {
    var p0 = text_element.selectionStart;
    var p1 = text_element.selectionEnd;
    var top = text_element.scrollTop;
    var str = tag_text;
    var cur0 = p0 + open_tag.length;
    var cur1 = p0 + open_tag.length + str.length;
    while (p1 > p0 && text_element.value.substring(p1-1, p1) == ' ') p1--; 
    if (p1 > p0) {
      str = text_element.value.substring(p0, p1);
      cur0 = p0 + open_tag.length + str.length + close_tag.length;
      cur1 = cur0;
    }
    text_element.value = text_element.value.substring(0,p0) + open_tag + str + close_tag + text_element.value.substring(p1);
    text_element.focus();
    text_element.selectionStart = cur0;
    text_element.selectionEnd = cur1;
    text_element.scrollTop = top;
  } else if (document.selection) {
    var str = document.selection.createRange().text;
    text_element.focus();
    range = document.selection.createRange()
    if (str == '') {
      range.text = open_tag + tag_text + close_tag;
      range.moveStart('character', -close_tag.length - tag_text.length );
      range.moveEnd('character', -close_tag.length );
    } else {
      if (str.charAt(str.length - 1) == " ") {
        close_tag = close_tag + " ";
        str = str.substr(0, str.length - 1);
      }
      range.text = open_tag + str + close_tag;
    }
    range.select();
  } else { text_element.value += open_tag + tag_text + close_tag; }
  return;
}
</script>
END;
      if (!$this->textarea_show_controls) $jscript = '';
      return $jscript;
    }
    
    function html_body() {
      $function_name = $this->textarea_name.'_button_click';
      $textarea_text = stripslashes($this->textarea_text);
      $html = '';
      if ($this->textarea_show_controls) {
        $html = <<<HTML
<a href="#"><img onclick="$function_name('*','*','bold');" src="$this->images_url/button_bold.gif" alt="Bold" width="50" height="50" border="0"></a> 
<a href="#"><img onclick="$function_name('**','**','italics');" src="$this->images_url/button_italics.gif" alt="Italics" width="50" height="50" border="0"></a> 
<a href="#"><img onclick="$function_name('--','--','underline');" src="$this->images_url/button_underline.gif" alt="Underline" width="50" height="50" border="0"></a> 
<a href="#"><img onclick="$function_name('', '\\n#########','heading 1');" src="$this->images_url/button_heading1.gif" alt="Heading 1" width="50" height="50" border="0"></a> 
<a href="#"><img onclick="$function_name('', '\\n=========','heading 2');" src="$this->images_url/button_heading2.gif" alt="Heading 2" width="50" height="50" border="0"></a> 
<a href="#"><img onclick="$function_name('', '\\n---------','heading 3');" src="$this->images_url/button_heading3.gif" alt="Heading 3" width="50" height="50" border="0"></a> 
<a href="#"><img onclick="$function_name('{', '}','image url');" src="$this->images_url/button_inline_image.gif" alt="Inline image" width="50" height="50" border="0"></a> 
<a href="#"><img onclick="$function_name('[link url]', '[/]','link text');" src="$this->images_url/button_inline_link.gif" alt="Inline link" width="50" height="50" border="0"></a> 
<br>
HTML;
      }
      $html.= <<<TEXTAREA
<textarea name="$this->textarea_name" id="$this->textarea_id" style="$this->textarea_style" rows="$this->textarea_rows" cols="$this->textarea_cols">$textarea_text</textarea>
TEXTAREA;
      return $html;
    }
    
    function save_text() {
      $thimble_text = new ThimbleText();
      $html = $thimble_text->parse_text($this->textarea_text);
      if (!$this->table_id) {
        mysql_query("INSERT INTO `".$this->table_name."`(text, html) VALUES('".mysql_real_escape_string($this->textarea_text)."', '".mysql_real_escape_string($html)."')");
        $this->table_id = mysql_insert_id();
        return $this->table_id;
      } else {
        mysql_query("UPDATE `".$this->table_name."` SET text='".mysql_real_escape_string($this->textarea_text)."', html='".mysql_real_escape_string($html)."' WHERE id='".$this->table_id."'");
        return $this->table_id;
      }
    }
    
  }

?>