<?php

function test_run($servers, $lang_text, $data_dir, $number_of_requests) {
  
 $start_time = time();

 $fp = array();

 foreach ($servers as $server_name => $server_url) {
   $data_file = $data_dir.date("Y-m-d-H-i").'-'.$server_name.'.tst';
   if (!$fp[$server_name] = fopen($data_file, "w")) {
     die($lang_text['file_open_failed'].': '.$datovy_soubor);
   }
 }

 
 $url_time = time();
 $url_count = 0;
 $url_count_total = 0;
 $elapsed_seconds = 0;
 for ($i = 0; $i < $number_of_requests; $i++) {

   foreach ($servers as $server_name => $server_url) {
     $render_cas = file_get_contents($server_url);
     fwrite($fp[$server_name], $render_cas."\n");
     $url_count++;
     if ($url_time < time()) {
       $elapsed_seconds += (time() - $url_time);
       $url_time = time();
       $url_count_total += $url_count;
       echo $lang_text['elapsed_time'].': '.$elapsed_seconds;
       echo ', '.$url_count.' '.$lang_text['requests_in_second'];
       echo ', '.(($number_of_requests * count($servers)) - $url_count_total).' '.$lang_text['remaining_requests'];
       echo "<br>\n";
       flush();
       $url_count = 0;
     }
   }

 }

 foreach ($servers as $server_name => $server_url) {
   fclose($fp[$server_name]);
 }

 echo $lang_text['test_finished']."! (".$lang_text['elapsed_time'].': '.(time()-$start_time)." s)";

}

?>