/*

  Author - Rudolf Naprstek
  Website - http://www.thimbleopensource.com/tutorials-snippets/jquery-libraries-loader
  Version - 1.0.0
  Release - 12th August 2013

  usage example:

 var libraries = { 
  'tablesorter':['/ js/jquery.tablesorter.js'],
  'qtip':['/js/jquery.qtip2.js', '/css/jquery.qtip2.css'],
  'google_loader':['https://www.google.com/jsapi'] 
};

library('tablesorter', function(){ 
  $('#table').tablesorter(); 
});

*/

var getScript = jQuery.getScript;
jQuery.getScript = function( resources, callback ) {
  var length = resources.length, handler = function() { counter++; }, deferreds = [], counter = 0, idx = 0;
  for ( ; idx < length; idx++ ) {
    deferreds.push(
      getScript( resources[ idx ], handler )
    );
  }
  jQuery.when.apply( null, deferreds ).then(function() {
    callback && callback();
  });
};

function library(lib_name, callback) {
  if (lib_name in libraries) {
    if (library_loaded(lib_name)) {
      callback();
    } else {
      var attached = false;
      var js_files_to_load = [];
      $.each(libraries[lib_name], function(i, file){
        if (typeof injected_lib_files[file] == 'undefined' && file.indexOf('.css') > -1) {
          $('head').append('<link rel="stylesheet" href="'+file+'" type="text/css" />');
          injected_lib_files[file] = {status:'loaded', first_library:lib_name};
        } else {
          if ($.isPlainObject(injected_lib_files[file]) && injected_lib_files[file].status == 'loading') {
            attached = injected_lib_files[file].first_library;
            return false;
          }
          if ($.isPlainObject(injected_lib_files[file]) && injected_lib_files[file].status == 'loaded') return true;
          js_files_to_load.push(file);
          injected_lib_files[file] = {status:'loading', first_library:lib_name};
        }
      });
      if (attached) {
        $('body').on('library_'+attached+'_loaded', function(){
          $('body').off('library_'+attached+'_loaded');
          library(lib_name, callback);
        });
        return;
      }
      $.getScript(js_files_to_load, function(){
        library_loaded(lib_name, true);
        callback();
      }); 
    }
  } 
}

function library_loaded(lib_name, set_loaded) {
  if (typeof set_loaded == 'undefined') {
    return (loaded_libraries.hasOwnProperty(lib_name));
  } else {
    loaded_libraries[lib_name] = true;
    $.each(libraries[lib_name], function(i, v){
      injected_lib_files[v].status = 'loaded';
    });
    $('body').trigger('library_'+lib_name+'_loaded');
  }
}